<?
/*
	EasyRanx (developer version) 
	Version 1.0 
	This script is part of onlinetools.org http://www.onlinetools.org
	and was written by Chris Heilmann.
	Please see homepage for details and ask for advice in the forum on
	onlinetools.org
*/

// Variables...
$button_caption = "Rank this!"; // Text on Send Button
$full_color = "ff0000"; 		// Color of submitted votes rectangle
$empty_color = "cccccc"; 		// Color of empty votes rectangle
$max = 10;						// Max amount of selectbox

// Display, this is the html displayed, you can use these variables:

// %select% - will be replaced by the selectbox
// %submit% - will be the submit button with the caption text
// %table% 	- will be table with the results (colored rectangles)
// %all% 	- number of votes
// %avg% 	- average ranking with two decimals
// %max% 	- the max ranking

$display ='
<table width="200" border="0" cellpadding="2" cellspacing="1">
<tr>
	<td bgcolor="#333333">
	<table width="100%" border="0" cellpadding="5" cellspacing="0">
	<tr>
		<td bgcolor="#cccccc">
			<font face="verdana" size="2">
				<b>Rank this!</b>
			</font>
		</td>
	</tr>
	<tr>
		<td bgcolor="#ffffff" align="center">
			<font face="verdana" size="1">
				%select%%submit%
				<br /><br />
				%table%
				<br />
				%all% people gave this an average of %avg% of %max%
			</font>
		</td>
	</tr>
	</table>
	</td>
</tr>
</table>
';

// Get rankings
$ranks=load("easyranks.txt");
$ranx=explode("#",$ranks);
foreach ($ranx as $tmp){
	$all+=$tmp;
}
// calculate average
$avg=$all/(sizeof($ranx)-1);

// assemble table
$table.= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\"><tr>";
for ($i=1;$i<($max+1);$i++){
	if ($i<$avg){$bg=$full_color;}
	else {$bg=$empty_color;}
	$table.= "<td bgcolor=\"#$bg\" width=\"8\">&nbsp;</td>";
}
$table.= "</tr></table>";

// create dropdown
$select="<select name=\"rank\">";
for ($i=1;$i<($max+1);$i++){
	$select.="<option value=\"$i\">$i</option>";
	}
$select.="</select>";

// create submit button
$submit.="<input type=\"submit\" value=\"$button_caption\">";

// populate variables in template file
$display=str_replace("%all%",sizeof($ranx)-1,$display);
$display=str_replace("%table%",$table,$display);
$display=str_replace("%select%",$select,$display);
$display=str_replace("%submit%",$submit,$display);
$display=str_replace("%max%",$max,$display);
$chunks=explode("%avg%",$display);

// print out template file
echo "\n<!-- Start of easyranks -->\n<form>";
echo $chunks[0];
printf("%.2f", $avg);
echo $chunks[1];
echo"</form>\n<!-- end of easyranks (http://www.onlinetools.org/easyranks) -->\n";

// store entered rank in rankingsfile
if ($rank){
	$ranks.="#".$rank;
	save("easyranks.txt",$ranks);
}

#### Reused functions ####

/*
	Function load($file)
	reads the content of the file that you send and returns it
*/
function load($filelocation){
	if (file_exists($filelocation)){
		$newfile = fopen($filelocation,"r");
		$file_content = fread($newfile, filesize($filelocation));
		fclose($newfile);
		return $file_content;
		}
	}

/*
	Function save($file,$content)
	writes the content to the file and generates it if needed
*/
function save($filelocation,$newdatas){
	$newfile = fopen($filelocation,"w+");
	fwrite($newfile, $newdatas);
	fclose($newfile);
	}

/*
	Function untag($string,$tag){
	filters the content of tag $tag from $string and returns it
*/
function untag($string,$tag){
	$tmpval="";
	$preg="/<".$tag.">(.*?)<\/".$tag.">/si";
	preg_match_all($preg,$string,$tags); 
	foreach ($tags[1] as $tmpcont){
		$tmpval.=$tmpcont;
		}
	return $tmpval;
}	
?>
