<?
/*
	EasyRanx 
	Version 1.0 
	This script is part of onlinetools.org http://www.onlinetools.org
	and was written by Chris Heilmann.
	Please see homepage for details and ask for advice in the forum on
	onlinetools.org
*/

// Get data from the config file...
$config=load("config.xml");
$button_caption = untag($config,"buttontext");
$full_color = untag($config,"fullcolor");
$empty_color = untag($config,"emptycolor");
$max = untag($config,"max");

// get Template file
$display=load(untag($config,"template"));

// Get rankings
$ranks=load("easyranks.txt");
$ranx=explode("#",$ranks);
foreach ($ranx as $tmp){
	$all+=$tmp;
}
// calculate average
$avg=$all/(sizeof($ranx)-1);

// assemble table
$table.= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\"><tr>";
for ($i=1;$i<($max+1);$i++){
	if ($i<$avg){$bg=$full_color;}
	else {$bg=$empty_color;}
	$table.= "<td bgcolor=\"#$bg\" width=\"8\">&nbsp;</td>";
}
$table.= "</tr></table>";

// create dropdown
$select="<select name=\"rank\">";
for ($i=1;$i<($max+1);$i++){
	$select.="<option value=\"$i\">$i</option>";
	}
$select.="</select>";

// create submit button
$submit.="<input type=\"submit\" value=\"$button_caption\">";

// populate variables in template file
$display=str_replace("%all%",sizeof($ranx)-1,$display);
$display=str_replace("%table%",$table,$display);
$display=str_replace("%select%",$select,$display);
$display=str_replace("%submit%",$submit,$display);
$display=str_replace("%max%",$max,$display);
$chunks=explode("%avg%",$display);

// print out template file
echo "\n<!-- Start of easyranks -->\n<form>";
echo $chunks[0];
printf("%.2f", $avg);
echo $chunks[1];
echo"</form>\n<!-- end of easyranks (http://www.onlinetools.org/easyranks) -->\n";

// store entered rank in rankingsfile
if ($rank){
	$ranks.="#".$rank;
	save("easyranks.txt",$ranks);
}

#### Reused functions ####

/*
	Function load($file)
	reads the content of the file that you send and returns it
*/
function load($filelocation){
	if (file_exists($filelocation)){
		$newfile = fopen($filelocation,"r");
		$file_content = fread($newfile, filesize($filelocation));
		fclose($newfile);
		return $file_content;
		}
	}

/*
	Function save($file,$content)
	writes the content to the file and generates it if needed
*/
function save($filelocation,$newdatas){
	$newfile = fopen($filelocation,"w+");
	fwrite($newfile, $newdatas);
	fclose($newfile);
	}

/*
	Function untag($string,$tag){
	filters the content of tag $tag from $string and returns it
*/
function untag($string,$tag){
	$tmpval="";
	$preg="/<".$tag.">(.*?)<\/".$tag.">/si";
	preg_match_all($preg,$string,$tags); 
	foreach ($tags[1] as $tmpcont){
		$tmpval.=$tmpcont;
		}
	return $tmpval;
}	
?>
