<?PHP
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			Easycounter v1.1 
			by Chris Heilmann (info@onlinetools.org) 
			Feel free to use it, but don't delete these lines. 
			If you use it on your page, a link back to its homepage would
			be highly appreciated.
			Homepage: http://www.onlinetools.org/easycounter/
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
$c=strip_tags($_GET['c']);
 
/* To avoid the counter to increase, add a ?c=0 to the url when you call it */ 
  
// This defines the number of digits displayed... 
// if digits is set the number will be padded with the paddingchar.
$digits = 6;

// the char to pad the number with, in this case 62 -> 000062
$paddingchar="0";

// This defines the character in between each pack of thousands like 1.999.
$thousandsdelimiter = ".";

// This is the filename of the counterfile. If you want to use another name, 
// change it here and   rename the .txt file.
$filelocation="entercounter.txt";

// no counterfile yet? write one
if (!file_exists($filelocation)) {
	$newfile = fopen($filelocation,"w+");
	$content=1;
	fwrite($newfile, $content);
	fclose($newfile);
}

// read counterfile, increase content and rewrite it
$newfile = fopen($filelocation,"r");
$content = fread($newfile, filesize($filelocation));
fclose($newfile);
$newfile = fopen($filelocation,"w+");

// when c is set, don't increase counter else increase
if ($c==''){$content++;}

fwrite($newfile, $content);
fclose($newfile);

// if the number of digits is set, pad with paddingchar
if ($digits){
	$out="";
		if (strlen($content) < $digits){
			for ($i=0;$i<$digits-strlen($content);$i++){
				$out.=$paddingchar;
			}
			$content=$out.$content;
		}
}
// else set thousands delimitor, and display
else {
	$out=number_format($content);
	$content=str_replace(",",$thousandsdelimiter,$out);
}
echo $content;

?>