<?
/*
	EasyCounter
	Version 1.1 
	This script is part of onlinetools.org http://www.onlinetools.org
	and was written by Chris Heilmann.
	Please see homepage for details and ask for advice in the forum on
	onlinetools.org
*/

// Get data from the config file...
$c=strip_tags($_GET['c']);
$config=load("config.xml");
$digits = untag($config,"digits");
$paddingchar = untag($config,"paddingchar");
$thousandsdelimiter = untag($config,"thousandsdelimiter");
$filelocation = untag($config,"filelocation");

// no counterfile yet? write one
if (!file_exists($filelocation)) {
	$newfile = fopen($filelocation,"w+");
	$content=1;
	fwrite($newfile, $content);
	fclose($newfile);
}

// read counterfile, increase content and rewrite it
$newfile = fopen($filelocation,"r");
$content = fread($newfile, filesize($filelocation));
fclose($newfile);
$newfile = fopen($filelocation,"w+");

// when c is set, don't increase counter else increase
if ($c==''){$content++;}

fwrite($newfile, $content);
fclose($newfile);

// if the number of digits is set, pad with paddingchar
if ($digits!=""){
	$out="";
		if (strlen($content) < $digits){
			for ($i=0;$i<$digits-strlen($content);$i++){
				$out.=$paddingchar;
			}
			$content=$out.$content;
		}
}
// else set thousands delimitor, and display
else{
	$out=number_format($content);
	$content=str_replace(",",$thousandsdelimiter,$out);
	}
echo $content;
/*
	Function untag($string,$tag){
	filters the content of tag $tag from $string and returns it
*/
function untag($string,$tag){
	$tmpval="";
	$preg="/<".$tag.">(.*?)<\/".$tag.">/si";
	preg_match_all($preg,$string,$tags); 
	foreach ($tags[1] as $tmpcont){
		$tmpval.=$tmpcont;
		}
	return $tmpval;
}	
/*
	Function load($file)
	reads the content of the file that you send and returns it
*/
function load($filelocation){
	if (file_exists($filelocation)){
		$newfile = fopen($filelocation,"r");
		$file_content = fread($newfile, filesize($filelocation));
		fclose($newfile);
		return $file_content;
		}
	}
?>
