<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	
<html dir="ltr" xml:lang="en" lang="en">
<head>
	<title>EasyTemplate</title>
	<link rel="stylesheet" href="basic.css" type="text/css" />
	<style type="text/css" media="screen">
		@import "easytemplate.css";
	</style>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" /> 
</head>

<body>
<?php include_once('easytemplate.php');?>
	<div id="fixed">
		<img src="easytemplatelogo.gif" width="180" height="30" alt="EasyTemplate logo" />
		<a href="#contentstart" class="audial">Skip navigation?</a>
		<a name="menu" id="menu"></a>
		<ul>
		<li><a href="#EasyTemplate">EasyTemplate</a>
			<ul>
				<li><a href="#Why">Why EasyTemplate</a></li>
				<li><a href="#Demofiles">Demofiles</a></li>
				<li><a href="#Usage">Usage/Copyright</a></li>
				<li><a href="#Download">Download</a></li>
			</ul>
		</li>
		<li><a href="#HTMLtemplates">The HTML Templates</a>
			<ul>
				<li><a href="#HTMLpara">Parameters</a></li>
				<li><a href="#HTMLsections">Sections</a></li>
				<li><a href="#HTMLvariables">Variables</a></li>
				<li><a href="#HTMLcomments">Comments</a></li>
			</ul>
		</li>
		<li><a href="#PHPfunctions">The PHP functions</a>
			<ul>
				<li><a href="#setvar">setvar()</a></li>
				<li><a href="#getpara">getHTMLpara()</a></li>
				<li><a href="#getHTML">getHTML()</a></li>
				<li><a href="#delHTML">delHTML()</a></li>
				<li><a href="#replaceHTML">replaceHTML()</a></li>
				<li><a href="#cleanup">cleanup()</a></li>
				<li><a href="#load">load()</a></li>
				<li><a href="#save">save()</a></li>
			</ul>
		</li>
	</ul>
	<a href="easytemplate.zip" title="download EasyTemplate">Download (.ZIP)</a>
	</div>
	<div id="container">
	<a name="contentstart" id="contentstart" class="audial">Content starts.</a>
	<div id="content">
		<a name="EasyTemplate" id="EasyTemplate"></a><h3>EasyTemplate</h3>
			<p>EasyTemplate is a set of functions and HTML scripting techniques, 
			that make it easier to develop low level PHP solutions. Scripting
			solutions done with EasyTemplate can be maintained by HTML 
			developers without any PHP knowledge.</p>
			
			<p>EasyTemplate is not another PHP templating language like 
			<a href="http://smarty.php.net/">Smarty</a>, developers do not have 
			to learn any new tags or command strings and there is no programming 
			logic in the HTML files.</p>
			
			<p>All the functionality of the PHP script is triggered via HTML 
			comments.</p>
	
			<p>This is not a new idea, there has been a discussion on this issue 
			on <a href="http://www.phpbuilder.com/columns/lep20020402.php3">PHPBuilder</a> 
			a long time ago, and loads of emails and messages were exchanged on 
			the subject.</p>
			
			<p>Many other developers also came up with solutions, but most of 
			them required either to add invalid markup into the HTML template, 
			or the PHP functionality was rather advanced.</p>
			
			<p>EasyTemplate targets PHP Developers that produce scripts that will 
			be used by HTML developers and agencies that do not want to know about
			programming logic, but rather concentrate on developing nice HTML. 
			One of the requirements for being able to do that, is to be able to 
			see the changes you do in your HTML without using the PHP backend.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>

		<a name="Why" id="Why"></a><h4>Why EasyTemplate</h4>
			<p>One of the main reasons why PHP is so successful is it's low 
			learning curve. Any HTML developer with some insight into JavaScript
			or PERL is able to learn it fast.</p>
			<p>The ability of PHP to be mixed with HTML leads to the first 
			scripting attempts being satisfying and that is why there is a lot
			of PHP code out there mixing markup with logic.</p>
			<p>This makes &#34;real&#34; programmers shiver and see PHP just as
			another one scripting language, and not to be taken	serious.</p>
			<p>Mixing display and logic is fast, easy and also makes debugging 
			easy, but is poison, should a change of layout be necessary.</p>
			<p>For example this bit of code:</p>
<div class="code"><code>
echo &#34;&#60;table&#62;&#34;;
while ($row = mysql_fetch_array($sql_result)) {
	echo &#34;&#60;TR&#34;;
	$i++;
	$rowcolor=$i%2==0?'#cccccc':'#eeeeee';
	echo &#34; bgcolor=\&#34;$rowcolor\&#34;&#62;&#34;;
	echo &#34;&#60;TD&#62;&#34;.$row['NAME'].&#34;&#60;/TD&#62;&#34;;
	echo &#34;&#60;TD&#62;&#34;.$row['BIRTHDAY'].&#34;&#60;/TD&#62;&#34;;
	echo &#34;&#60;TD&#62;&#34;.$row['DEPARTMENT'].&#34;&#60;/TD&#62;&#34;;
	echo &#34;&#60;/TR&#62;&#34;;
}
echo&#34;&#60;/table&#62;&#34;;
</code></div>			
		<p>Is perfectly understandable to a PHP developer, but an graphical 
		design oriented HTML developer has a real problem changing anything 
		in there.</p>
		<p>As a Front End Developer, I do not want to care about how to 
		retrieve the data, or what logic has to dictate what gets displayed.</p>
		<p>As a PHP developer, I do not want to care, how some subtle change in 
		the site is done, or I don't want to be asked to do changes in copy 
		text.</p>
		<p>By using EasyTemplate, the same result as above can be achieved by 
		the following, completely separated PHP and HTML documents.</p>

<div class="code"><code>
<strong>PHP</strong>:
include_once('easytemplate.php');
$HTML=load(&#34;template.HTML&#34;);
while ($row = mysql_fetch_array($sql_result)) {
	$i++;
	$rowHTML=$i%2==0?getHTML($HTML,'rowcolor1'):getHTML($HTML,'rowcolor2');
	$rowHTML=setVar($rowHTML,'name',$row[&#34;NAME&#34;]);
	$rowHTML=setVar($rowHTML,'birthday',$row[&#34;BIRTHDAY&#34;]);
	$rowHTML=setVar($rowHTML,'department',$row[&#34;DEPARTMENT&#34;]);
	$incHTML.=$rowHTML;
}
$HTML=replaceHTML($HTML,'rows',$incHTML);
echo cleanup($HTML);

<strong>HTML</strong>:
&#60;table&#62;
&#60;-- start:rows --&#62;
&#60;-- start:rowcolor1 --&#62;
&#60;tr bgcolor=&#34;#eeeeee&#34;&#62;
	&#60;td&#62;%%name%%&#60;/td&#62;
	&#60;td&#62;%%birthday%%&#60;/td&#62;
	&#60;td&#62;%%department%%&#60;/td&#62;
&#60;/tr&#62;
&#60;-- end:rowcolor1 --&#62;
&#60;-- start:rowcolor2 --&#62;
&#60;tr bgcolor=&#34;#cccccc&#34;&#62;
	&#60;td&#62;%%name%%&#60;/td&#62;
	&#60;td&#62;%%birthday%%&#60;/td&#62;
	&#60;td&#62;%%department%%&#60;/td&#62;
&#60;/tr&#62;
&#60;-- end:rowcolor2 --&#62;
&#60;-- end:rows --&#62;
&#60;/table&#62;
</code></div>
		<p>Or, if the HTML template is meant to be shorter, you can use parameters:</p>
<div class="code"><code>
<strong>PHP</strong>:
include_once('easytemplate.php');
$HTML=load(&#34;template.HTML&#34;);
while ($row = mysql_fetch_array($sql_result)) {
	$i++;
	$rowHTML=getHTML($HTML,'row');
	$rowcol=$i%2==0?getHTMLpara($HTML,'rowcolor1'):getHTMLpara($HTML,'rowcolor2');
	$rowHTML=setVar($rowHTML,'color',$rowcol);
	$rowHTML=setVar($rowHTML,'name',$row[&#34;NAME&#34;]);
	$rowHTML=setVar($rowHTML,'birthday',$row[&#34;BIRTHDAY&#34;]);
	$rowHTML=setVar($rowHTML,'department',$row[&#34;DEPARTMENT&#34;]);
	$incHTML.=$rowHTML;
}
$HTML=replaceHTML($HTML,'row',$incHTML);
echo cleanup($HTML);

<strong>HTML</strong>:
&#60;-- rowcolor1:cccccc --&#62;
&#60;-- rowcolor2:eeeeee --&#62;
&#60;table&#62;
&#60;-- start:row --&#62;
&#60;tr bgcolor=&#34;#%%color%%&#34;&#62;
	&#60;td&#62;%%name%%&#60;/td&#62;
	&#60;td&#62;%%birthday%%&#60;/td&#62;
	&#60;td&#62;%%department%%&#60;/td&#62;
&#60;/tr&#62;
&#60;-- end:row --&#62;
&#60;/table&#62;
</code></div>
		<p>At first glance, it looks complicated, but it isn't. Once both 
		developers got used to the function names and the comment syntax,
		building modular scripts and pages is very easy.</p>
		<p>The HTML developer has complete control over the layout, all the 
		HTML can be developed and checked in a browser, the PHP developer
		can concentrate on the programming logic and populating the variables 
		in the HTML.</p>
		<p>Once this logic is finished, any HTML display change can be done 
		without the need for a PHP savvy developer.</p>
		<p>It is a technique of taking PHP from the sloppy way of scripting to 
		a better, cleaner and more logical level, and all this just by reusing 
		some functions.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>

		<a name="Demofiles" id="Demofiles"></a><h4>Demofiles</h4>
		<p>These are some examples how to use EasyTemplate.</p>
		<p><a href="demo.php">Example 1</a> (<a href="showsrc.php?s=&#38;l=h">HTML#1</a>)
		(<a href="showsrc.php?s=&#38;l=p">PHP#1</a>)</p>
		<p>This example shows how to create a small Login/Namecheck screen. A 
		form is displayed and the entered Name compared to an admin name in a 
		HTML parameter. If the name is the admin's name, an admin link gets 
		displayed, if not, a simple welcome message.</p>
		<p><a href="demo2.php">Example 2</a> (<a href="showsrc.php?s=2&#38;l=h">HTML#2</a>)
		(<a href="showsrc.php?s=2&#38;l=p">PHP#2</a>)</p>
		<p>This example shows how to create a results table with alternate 
		colours in each row. The items to display, the amount of items displayed
		each time and the colours are defined via parameters. HTML sections 
		define the next and previous links, and the row to display for each 
		item. The PHP computes all the necessary logic.</p>
		<p><a href="demo3.php">Example 3</a> (<a href="showsrc.php?s=3&#38;l=h">HTML#3</a>)
		(<a href="showsrc.php?s=3&#38;l=p">PHP#3</a>)</p>
		<p>This example shows how to create a formmailer. The Form, the return 
		page and the email body get defined via HTML sections.The email subject,
		where it came from, where it gets sent to and the mandatory fields in the
		form are defined as HTML parameters. The mail() function is disabled in 
		this example, simply uncomment the mail() line to make it work.</p>

		<a name="Usage" id="Usage"></a><h4>Usage/Copyright</h4>
			<p>EasyTemplate is free for use at the moment, given great acceptance,
			I plan to move it onto sourceforge and make it Open Source.</p>
			<p>For the moment please keep in contact if you plan to do any 
			modifications.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="Download" id="Download"></a><h4>Download</h4>
			<p>You can download this instructions file, the demofiles and 
			EasyTemplate as one zip file by clicking the link below.</p>
			<p><strong><a href="easytemplate.zip">Download EasyTemplate (.zip -  
			<? echo round(filesize('easytemplate.zip')/1024);?> KB)</a></strong></p>
			<p>Version 1.0 21.January 2003</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="HTMLtemplates" id="HTMLtemplates"></a>
		<h3>The HTML Templates</h3>
			<p>The idea of EasyTemplate was to allow developers with HTML 
			knowledge to define elements of the page which get displayed or 
			not according to what the programming logic dictates.</p>
			<p>Another requirement is paramaters, that will be used by the PHP 
			script.</p>
			<p>Furthermore there was a necessity for variables, which will be 
			populated by the PHP script.</p>
			<p>To keep all of this as easy as possible for the HTML developer, 
			most of this functionality is achieved via HTML comments. These 
			have the advantage that they are not displayed, which means the 
			developer can see the page as it will be without any disturbing 
			special tags or characters.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="HTMLpara" id="HTMLpara"></a>
		<h4>Parameters(Switches)</h4>
			<p>These are settings in the HTML template, that the PHP script 
			will read and use, their syntax is:</p>
<div class="code"><code>&#60;-- name:setting --&#62;</code></div>
			<p>For example <strong>&#60;-- Items:5 --&#62;</strong> sets the 
			amount of &#34;Items&#34; to &#34;5&#34;, 
			<strong>&#60;!-- owner:admin@foo.com --&#62;</strong> sets 
			&#34;owner&#34; to &#34;admin@foo.com&#34;.</p>
			<p class="warning">Beware: Parameters have to be on one line. No linebreaks 
			are allowed.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="HTMLsections" id="HTMLsection"></a>
		<h4>Logical markup sections</h4>
			<p>These describe parts of the document, that are displayed or not, 
			dependent on the logic in the PHP script.</p>
<div class="code"><code>
&#60;-- start:section --&#62;
...HTML code...
&#60;-- end:section --&#62;
</code></div>
			<p>For example:</p>
<div class="code"><code>
&#60;-- start:Error --&#62;
&#60;p class=&#34;boo&#34;&#62;You forgot to enter the correct name.&#60;/p&#62;
&#60;-- end:Error --&#62;
</code></div>
			<p>Will be available to the PHP logic as &#34;Error&#34;.</p>
			<p class="warning">Beware: Sections have to be on several lines, without 
			linebreaks replaceHTML will not work.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="HTMLvariables" id="HTMLvariables"></a>
		<h4>Variables</h4>
			<p>Variables are parts of a markup section or the document that the 
			PHP logic replaces with the actual data. These are 
			<strong>not</strong> defined as HTML comments, to allow the HTML 
			developer to use them in attributes.</p>
<div class="code"><code>
&#60;div class=&#34;<strong>%%class%%</strong>&#62;
&#60;a href=&#34;<strong>%%link%%</strong>&#34; title=&#34;<strong>%%title%%</strong>&#34;&#62;<strong>%%linkdescription%%</strong>&#60;/a&#62;
&#60;/div&#62;
</code></div>
			<p>Each variable is defined by surrounding double percentage 
			characters. You can	use variables with the same name in different 
			sections of the page, unless the PHP developer does not do a 
			global replace, this will not affect the logic.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
			
			<a name="HTMLcomments" id="HTMLcomments"></a><h4>Comments</h4>
			<p>To allow commenting of the EasyTemplate templates, start the 
			line with a hash(#).</p>
<div class="code"><code>&#60;-- # This is a comment --&#62;</code></div>
			<p>These comments will be deleted when EasyTemplate prints out the
			 template. Normal HTML comments without the hash(#) stay as they are.</p>
			<p class="warning">Beware: Comments must be on one line.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="PHPfunctions" id="PHPfunctions"></a>
		<h3>The PHP functions</h3>
			<p>EasyTemplate works with a set of really small functions, that 
			are not more but some regular expressions. Each functions deals 
			with a different problem and/or HTML template command.</p>
		
		<a name="setvar" id="setvar"></a>
		<h4>setvar($doc,$var,$value)</h4>
			<p>This function <strong>replaces</strong> the variable 
			<strong>var</strong> in <strong>doc</strong> with the set
			 <strong>value</strong>.</p>
<div class="code"><code>
$HTML=setvar($HTML,'linkback',$HTTP_SERVER_VARS["HTTP_REFERER"]);
</code></div>
			<p>Replaces the HTML variable
			%%linkback%% with the refering page.</p>
<div class="code"><code>
$display=setvar(getHTML($HTML,'display'),'offset','300');
</code></div>
			<p>Replaces the HTML variable
			%%offset%% in the HTML section 
			&#34;display&#34; with &#34;300&#34; and populates the variable 
			$display with the resulting HTML.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="getpara" id="getpara"></a>
		<h4>getHTMLpara($doc,$sw)</h4>
			<p>This function <strong>reads</strong> the value of the 
			HTML parameter <strong>sw</strong> in 
			the document <strong>doc</strong>.</p>
<div class="code"><code>
$amount=getHTMLpara($HTML,'amount');
</code></div>
			<p>Reads the value of the 
			HTML parameter amount and populates 
			the variable amount with it. The parameter &#60;-- amount:20 --&#62; 
			would result in amount becoming 20.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="getHTML" id="getHTML"></a>
		<h4>getHTML($doc,$elm)</h4>
			<p>This function <strong>reads</strong> the 
			HTML section<strong>elm</strong> in the 
			document <strong>doc</strong>.</p>
<div class="code"><code>
$error=getHTML($HTML,'error');
</code></div>
			<p>Reads the HTML in between &#60;-- start:error --&#62; and 
			&#60;-- end:error --&#62; and populates the variable error with it.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="delHTML" id="delHTML"></a>
		<h4>delHTML($doc,$elm)</h4>
			<p>This function <strong>deletes</strong> the 
			HTML sections <strong>elm</strong> in 
			the document <strong>doc</strong>. Separate the sections 
			with a comma.</p>
<div class="code"><code>
$doc=delHTML($doc,'error');
</code></div>
			<p>Deletes the HTML in between &#60;-- start:error --&#62; and 
			&#60;-- end:error --&#62; in the document doc.</p>
<div class="code"><code>
$doc=delHTML($HTML,'form,display');
</code></div>
			<p>Deletes the HTML in between &#60;-- start:form --&#62; and 
			&#60;-- end:form --&#62; and the HTML in between 
			&#60;-- start:form --&#62; and &#60;-- end:form --&#62; in the 
			document doc.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="replaceHTML" id="replaceHTML"></a>
		<h4>replaceHTML($doc,$elm,$new)</h4>
			<p>This function <strong>replaces</strong> the 
			HTML section <strong>elm</strong> in the 
			document <strong>doc</strong> with the variable 
			<strong>new</strong>.</p>
<div class="code"><code>
$doc=replaceHTML($doc,'error','There are no errors to report.');
</code></div>
			<p>Replaces the HTML in between &#60;-- start:error --&#62; and 
			&#60;-- end:error --&#62; in the document doc with &#34;There are 
			no errors to report.&#34;.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
			
		<a name="cleanup" id="cleanup"></a>
		<h4>cleanup($doc)</h4>
			<p>This function <strong>deletes</strong> all EasyTemplate comments 
			and parameters in the document <strong>doc</strong>.</p>
<div class="code"><code>
echo cleanup($HTML);
</code></div>
			<p>Could be the last line in the PHP to display the results.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="load" id="load"></a>
		<h4>load($file)</h4>
			<p>This function <strong>loads</strong> the file &#34;file&#34;.</p>
<div class="code"><code>
$HTML=load('template.HTML');
</code></div>
			<p>Populates &#34;<strong>HTML</strong>&#34; with the content of 
			the file &#34;<strong>template.HTML</strong>&#34;. If the file does 
			not exist, HTML will be empty.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		
		<a name="save" id="save"></a>
			<h4>save($filelocation,$newdatas)</h4>
			<p>This function <strong>stores</strong> the content of 
			&#34;newdatas&#34; in the file &#34;filelocation&#34;. If the 
			storing fails, the function returns &#34;1&#34;,otherwise &#34;0&#34;.</p>
<div class="code"><code>
$sure=save('template.HTML',$HTML);
if ($sure==1){echo 'There was an error saving the data!';}
</code></div>
			<p class="warning">Beware: To allow save() to store the data, the document needs to have 
			the correct filepermissions set.</p>
		<p class="backToMenu"><a href="#menu">Back to Menu</a></p>
		<p class="validators">
			Validity:&nbsp;
			<a href="http://validator.w3.org/check/referer">Valid XHTML 1.0</a>&nbsp;
			Accessibility:&nbsp;
			<a href="http://bobby.watchfire.com/" title="Bobby's Home Page">Approved AAA</a>&nbsp; 
			<a href="http://bobby.watchfire.com/" title="Bobby's Home Page">Approved 508</a></p>
		</div>
	</div>

</body>
</html>